<?php
include('./includes/config.php');

// Decode referral code (if any)
$ref_code = '';
if (isset($_GET['ref']) && !empty($_GET['ref'])) {
    $ref_code = base64_decode(mysqli_real_escape_string($ahk_conn, $_GET['ref']));
}

include('./template/ahkweb/authentication-signup.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['phone'])) {
    $name = mysqli_real_escape_string($ahk_conn, $_POST['name']);
    $email = mysqli_real_escape_string($ahk_conn, $_POST['email']);
    $phone = mysqli_real_escape_string($ahk_conn, $_POST['phone']);
    $usertype = mysqli_real_escape_string($ahk_conn, $_POST['usertype']);
    $password = $_POST['password'];
    // $cpassword = $_POST['cpassword'];
    $order_id = "Flx_" . rand(100000, 999999);
    $date = date("Y-m-d");

    // Prevent admin signup
    if (strcasecmp($usertype, "admin") === 0) {
        echo "<script>Swal.fire('Access Denied!', 'Invalid registration type.', 'error');</script>";
        exit;
    }

    // Check existing user
    $fdata = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$phone' OR email='$email'");
    if (mysqli_num_rows($fdata) > 0) {
        echo "<script>Swal.fire('Oops!', 'Email or phone already exists!', 'error');</script>";
        exit;
    }

    // Password validation
    // if ($password !== $cpassword) {
    //     echo "<script>Swal.fire('Oops!', 'Passwords do not match!', 'error');</script>";
    //     exit;
    // }

    $vpass = password_hash($password, PASSWORD_DEFAULT);

    // Determine registration amount
    $amount = 0;
    if ($usertype === "retailer") {
        $amount = $webdata['ret_reg_fee'];
    } elseif ($usertype === "distributor") {
        $amount = $webdata['dist_reg_fee'];
    } else {
        $amount = 999; // Default fallback
    }

    // ✅ Independent Free Registration Checks
    $isFreeRetailer = ($usertype === "retailer" && $webdata['ret_reg_fee'] == 0);
    $isFreeDistributor = ($usertype === "distributor" && $webdata['dist_reg_fee'] == 0);

    if ($isFreeRetailer || $isFreeDistributor) {
        // Direct registration without payment
        $res = mysqli_query($ahk_conn, "
            INSERT INTO users (name, phone, email, password, type, status, referred_by, order_id, date)
            VALUES ('$name', '$phone', '$email', '$vpass', '$usertype', '1', '$ref_code', '$order_id', '$date')
        ");

        // Referral bonus if available
        if ($ref_code) {
            mysqli_query($ahk_conn, "
                INSERT INTO referal (phone, referred_by, txn_no, referral_balance, status)
                VALUES ('$phone', '$ref_code', 'REF" . rand(10000, 99999) . "', '" . $webdata['ref_bal'] . "', '1')
            ");
        }

        if ($res) {
            echo "<script>
                Swal.fire({
                    title: 'Registration Successful!',
                    text: 'Your $usertype account has been created successfully. No payment required!',
                    icon: 'success',
                    confirmButtonText: 'Login Now'
                }).then(() => {
                    window.location.href = 'login.php';
                });
            </script>";
        } else {
            echo "<script>Swal.fire('Error!', 'Database insertion failed!', 'error');</script>";
        }
        exit;
    }

    // ✅ Else, registration requires payment
    $res = mysqli_query($ahk_conn, "
        INSERT INTO users (name, phone, email, password, type, status, referred_by, order_id, date)
        VALUES ('$name', '$phone', '$email', '$vpass', '$usertype', '0', '$ref_code', '$order_id', '$date')
    ");

    if (!$res) {
        echo "<script>Swal.fire('Error!', 'Database insertion failed!', 'error');</script>";
        exit;
    }

    // Referral bonus entry
    if ($ref_code) {
        mysqli_query($ahk_conn, "
            INSERT INTO referal (phone, referred_by, txn_no, referral_balance, status)
            VALUES ('$phone', '$ref_code', 'REF" . rand(10000, 99999) . "', '" . $webdata['ref_bal'] . "', '1')
        ");
    }

    // Payment mode handling
    $mode = $_POST['mode'] ?? '';

    if ($mode === "paytm") {
        echo "<form name='f2' method='post' action='./qr/pay.php'>
                <input type='hidden' name='ORDER_ID' value='$order_id'>
                <input type='hidden' name='CUST_ID' value='$phone'>
                <input type='hidden' name='INDUSTRY_TYPE_ID' value='Retail'>
                <input type='hidden' name='CHANNEL_ID' value='WEB'>
                <input type='hidden' name='TXN_AMOUNT' value='$amount'>
              </form>
              <script>document.f2.submit();</script>";
    } elseif ($mode === "qr") {
        mysqli_query($ahk_conn, "
            INSERT INTO wallet (phone, amount, txn_id, email, status, date, PAYMENTMODE)
            VALUES ('$phone', '$amount', '$order_id', '$email', 'pending', '$date', 'REGQR')
        ");
        echo "<form method='post' name='f2' action='Flex4uPoint4in1/regpg.php'>
                <input type='hidden' name='frompage' value='reg'>
                <input type='hidden' name='order_id' value='$order_id'>
                <input type='hidden' name='phone' value='$phone'>
                <input type='hidden' name='amount' value='$amount'>
              </form>
              <script>document.f2.submit();</script>";
    }
}

// ✅ Payment return handlers
if (!empty($_POST['successmsg']) && $_POST['successmsg'] === "true") {
    echo "<script>Swal.fire('Success!', 'Your account was created successfully!', 'success');</script>";
}
if (!empty($_POST['failedmsg']) && $_POST['failedmsg'] === "true") {
    echo "<script>Swal.fire('Payment Failed', 'If payment was deducted, contact support!', 'error');</script>";
}

// ✅ Optional SMS on success
if (!empty($phone) && !empty($name)) {
    $msg = urlencode("Dear $name, Registration successful! Your password is $password.");
    $api_url = "https://server.livesms.site/send-message?api_key=4pyeeAfgWYDGHO4or1M0mVCCOLP&sender=9112&number=91$phone&message=$msg";
    @file_get_contents($api_url);
}
?>
